/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceManagementTroubleshootingEvent;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceManagementTroubleshootingEventCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceManagementTroubleshootingEventCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceManagementTroubleshootingEventCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceManagementTroubleshootingEventRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceManagementTroubleshootingEventCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceManagementTroubleshootingEventCollectionRequest;
import java.util.List;

public class DeviceManagementTroubleshootingEventCollectionRequest
extends BaseCollectionRequest<DeviceManagementTroubleshootingEventCollectionResponse, IDeviceManagementTroubleshootingEventCollectionPage>
implements IDeviceManagementTroubleshootingEventCollectionRequest {
    public DeviceManagementTroubleshootingEventCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceManagementTroubleshootingEventCollectionResponse.class, IDeviceManagementTroubleshootingEventCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IDeviceManagementTroubleshootingEventCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceManagementTroubleshootingEventCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceManagementTroubleshootingEventCollectionPage get() throws ClientException {
        DeviceManagementTroubleshootingEventCollectionResponse response = (DeviceManagementTroubleshootingEventCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceManagementTroubleshootingEvent newDeviceManagementTroubleshootingEvent, ICallback<? super DeviceManagementTroubleshootingEvent> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceManagementTroubleshootingEventRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceManagementTroubleshootingEvent, callback);
    }

    @Override
    public DeviceManagementTroubleshootingEvent post(DeviceManagementTroubleshootingEvent newDeviceManagementTroubleshootingEvent) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceManagementTroubleshootingEventRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceManagementTroubleshootingEvent);
    }

    @Override
    public IDeviceManagementTroubleshootingEventCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceManagementTroubleshootingEventCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IDeviceManagementTroubleshootingEventCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IDeviceManagementTroubleshootingEventCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceManagementTroubleshootingEventCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDeviceManagementTroubleshootingEventCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDeviceManagementTroubleshootingEventCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDeviceManagementTroubleshootingEventCollectionPage buildFromResponse(DeviceManagementTroubleshootingEventCollectionResponse response) {
        DeviceManagementTroubleshootingEventCollectionRequestBuilder builder = response.nextLink != null ? new DeviceManagementTroubleshootingEventCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceManagementTroubleshootingEventCollectionPage page = new DeviceManagementTroubleshootingEventCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

