/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.EducationClass;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IEducationClassWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class EducationClassWithReferenceRequest
extends BaseRequest
implements IEducationClassWithReferenceRequest {
    public EducationClassWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationClass.class);
    }

    @Override
    public void post(EducationClass newEducationClass, IJsonBackedObject payload, ICallback<? super EducationClass> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public EducationClass post(EducationClass newEducationClass, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newEducationClass;
        }
        return null;
    }

    @Override
    public void get(ICallback<? super EducationClass> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public EducationClass get() throws ClientException {
        return (EducationClass)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super EducationClass> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(EducationClass sourceEducationClass, ICallback<? super EducationClass> callback) {
        this.send(HttpMethod.PATCH, callback, sourceEducationClass);
    }

    @Override
    public EducationClass patch(EducationClass sourceEducationClass) throws ClientException {
        return (EducationClass)this.send(HttpMethod.PATCH, sourceEducationClass);
    }

    @Override
    public IEducationClassWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEducationClassWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

