// Template Source: BaseMethodCollectionRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;

import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IDirectoryObjectGetMemberGroupsCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetMemberGroupsCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetMemberGroupsCollectionResponse;
import com.microsoft.graph.models.extensions.DirectoryObjectGetMemberGroupsBody;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.concurrency.IExecutors;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Object Get Member Groups Collection Request.
 */
public class DirectoryObjectGetMemberGroupsCollectionRequest extends BaseCollectionRequest<DirectoryObjectGetMemberGroupsCollectionResponse, IDirectoryObjectGetMemberGroupsCollectionPage> implements IDirectoryObjectGetMemberGroupsCollectionRequest {


    protected final DirectoryObjectGetMemberGroupsBody body;


    /**
     * The request for this DirectoryObjectGetMemberGroups
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DirectoryObjectGetMemberGroupsCollectionRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObjectGetMemberGroupsCollectionResponse.class, IDirectoryObjectGetMemberGroupsCollectionPage.class);
        body = new DirectoryObjectGetMemberGroupsBody();
    }


    public void post(final ICallback<? super IDirectoryObjectGetMemberGroupsCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(post(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IDirectoryObjectGetMemberGroupsCollectionPage post() throws ClientException {
        final DirectoryObjectGetMemberGroupsCollectionResponse response = post(body);
        return buildFromResponse(response);
    }


    public IDirectoryObjectGetMemberGroupsCollectionPage buildFromResponse(final DirectoryObjectGetMemberGroupsCollectionResponse response) {
        final IDirectoryObjectGetMemberGroupsCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new DirectoryObjectGetMemberGroupsCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null, (Boolean) null);
        } else {
            builder = null;
        }
        final IDirectoryObjectGetMemberGroupsCollectionPage page = new DirectoryObjectGetMemberGroupsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IDirectoryObjectGetMemberGroupsCollectionRequest select(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$select", value));
        return (IDirectoryObjectGetMemberGroupsCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IDirectoryObjectGetMemberGroupsCollectionRequest top(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$top", value+""));
        return (IDirectoryObjectGetMemberGroupsCollectionRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IDirectoryObjectGetMemberGroupsCollectionRequest expand(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (IDirectoryObjectGetMemberGroupsCollectionRequest)this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    public IDirectoryObjectGetMemberGroupsCollectionRequest filter(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$filter", value));
        return (IDirectoryObjectGetMemberGroupsCollectionRequest)this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the order by clause
     * @return the updated request
     */
    public IDirectoryObjectGetMemberGroupsCollectionRequest orderBy(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$orderby", value));
        return (IDirectoryObjectGetMemberGroupsCollectionRequest)this;
    }

}
