// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Domain;
import com.microsoft.graph.requests.extensions.IDirectoryObjectCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IDirectoryObjectWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IDomainDnsRecordCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDomainDnsRecordRequestBuilder;
import com.microsoft.graph.requests.extensions.DomainDnsRecordCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DomainDnsRecordRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Domain Request.
 */
public class DomainRequest extends BaseRequest implements IDomainRequest {
	
    /**
     * The request for the Domain
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DomainRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Domain.class);
    }

    /**
     * Gets the Domain from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super Domain> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Domain from the service
     *
     * @return the Domain from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Domain get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super Domain> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Domain with a source
     *
     * @param sourceDomain the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final Domain sourceDomain, final ICallback<? super Domain> callback) {
        send(HttpMethod.PATCH, callback, sourceDomain);
    }

    /**
     * Patches this Domain with a source
     *
     * @param sourceDomain the source object with updates
     * @return the updated Domain
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Domain patch(final Domain sourceDomain) throws ClientException {
        return send(HttpMethod.PATCH, sourceDomain);
    }

    /**
     * Creates a Domain with a new object
     *
     * @param newDomain the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final Domain newDomain, final ICallback<? super Domain> callback) {
        send(HttpMethod.POST, callback, newDomain);
    }

    /**
     * Creates a Domain with a new object
     *
     * @param newDomain the new object to create
     * @return the created Domain
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Domain post(final Domain newDomain) throws ClientException {
        return send(HttpMethod.POST, newDomain);
    }

    /**
     * Creates a Domain with a new object
     *
     * @param newDomain the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final Domain newDomain, final ICallback<? super Domain> callback) {
        send(HttpMethod.PUT, callback, newDomain);
    }

    /**
     * Creates a Domain with a new object
     *
     * @param newDomain the object to create/update
     * @return the created Domain
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Domain put(final Domain newDomain) throws ClientException {
        return send(HttpMethod.PUT, newDomain);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IDomainRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (DomainRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IDomainRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (DomainRequest)this;
     }

}

