// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.BaseItem;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Item Request.
 */
public interface IBaseItemRequest extends IHttpRequest {

    /**
     * Gets the BaseItem from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super BaseItem> callback);

    /**
     * Gets the BaseItem from the service
     *
     * @return the BaseItem from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    BaseItem get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super BaseItem> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this BaseItem with a source
     *
     * @param sourceBaseItem the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final BaseItem sourceBaseItem, final ICallback<? super BaseItem> callback);

    /**
     * Patches this BaseItem with a source
     *
     * @param sourceBaseItem the source object with updates
     * @return the updated BaseItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    BaseItem patch(final BaseItem sourceBaseItem) throws ClientException;

    /**
     * Posts a BaseItem with a new object
     *
     * @param newBaseItem the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final BaseItem newBaseItem, final ICallback<? super BaseItem> callback);

    /**
     * Posts a BaseItem with a new object
     *
     * @param newBaseItem the new object to create
     * @return the created BaseItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    BaseItem post(final BaseItem newBaseItem) throws ClientException;

    /**
     * Posts a BaseItem with a new object
     *
     * @param newBaseItem the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final BaseItem newBaseItem, final ICallback<? super BaseItem> callback);

    /**
     * Posts a BaseItem with a new object
     *
     * @param newBaseItem the object to create/update
     * @return the created BaseItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    BaseItem put(final BaseItem newBaseItem) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IBaseItemRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IBaseItemRequest expand(final String value);

}

