// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.EnrollmentConfigurationAssignment;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Enrollment Configuration Assignment Request.
 */
public interface IEnrollmentConfigurationAssignmentRequest extends IHttpRequest {

    /**
     * Gets the EnrollmentConfigurationAssignment from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super EnrollmentConfigurationAssignment> callback);

    /**
     * Gets the EnrollmentConfigurationAssignment from the service
     *
     * @return the EnrollmentConfigurationAssignment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EnrollmentConfigurationAssignment get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super EnrollmentConfigurationAssignment> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this EnrollmentConfigurationAssignment with a source
     *
     * @param sourceEnrollmentConfigurationAssignment the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final EnrollmentConfigurationAssignment sourceEnrollmentConfigurationAssignment, final ICallback<? super EnrollmentConfigurationAssignment> callback);

    /**
     * Patches this EnrollmentConfigurationAssignment with a source
     *
     * @param sourceEnrollmentConfigurationAssignment the source object with updates
     * @return the updated EnrollmentConfigurationAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EnrollmentConfigurationAssignment patch(final EnrollmentConfigurationAssignment sourceEnrollmentConfigurationAssignment) throws ClientException;

    /**
     * Posts a EnrollmentConfigurationAssignment with a new object
     *
     * @param newEnrollmentConfigurationAssignment the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final EnrollmentConfigurationAssignment newEnrollmentConfigurationAssignment, final ICallback<? super EnrollmentConfigurationAssignment> callback);

    /**
     * Posts a EnrollmentConfigurationAssignment with a new object
     *
     * @param newEnrollmentConfigurationAssignment the new object to create
     * @return the created EnrollmentConfigurationAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EnrollmentConfigurationAssignment post(final EnrollmentConfigurationAssignment newEnrollmentConfigurationAssignment) throws ClientException;

    /**
     * Posts a EnrollmentConfigurationAssignment with a new object
     *
     * @param newEnrollmentConfigurationAssignment the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final EnrollmentConfigurationAssignment newEnrollmentConfigurationAssignment, final ICallback<? super EnrollmentConfigurationAssignment> callback);

    /**
     * Posts a EnrollmentConfigurationAssignment with a new object
     *
     * @param newEnrollmentConfigurationAssignment the object to create/update
     * @return the created EnrollmentConfigurationAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EnrollmentConfigurationAssignment put(final EnrollmentConfigurationAssignment newEnrollmentConfigurationAssignment) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IEnrollmentConfigurationAssignmentRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IEnrollmentConfigurationAssignmentRequest expand(final String value);

}

