// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.MicrosoftAuthenticatorAuthenticationMethodConfiguration;
import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodTargetRequestBuilder;
import com.microsoft.graph.requests.extensions.MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MicrosoftAuthenticatorAuthenticationMethodTargetRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Microsoft Authenticator Authentication Method Configuration Request Builder.
 */
public class MicrosoftAuthenticatorAuthenticationMethodConfigurationRequestBuilder extends BaseRequestBuilder implements IMicrosoftAuthenticatorAuthenticationMethodConfigurationRequestBuilder {

    /**
     * The request builder for the MicrosoftAuthenticatorAuthenticationMethodConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MicrosoftAuthenticatorAuthenticationMethodConfigurationRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IMicrosoftAuthenticatorAuthenticationMethodConfigurationRequest instance
     */
    public IMicrosoftAuthenticatorAuthenticationMethodConfigurationRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IMicrosoftAuthenticatorAuthenticationMethodConfigurationRequest instance
     */
    public IMicrosoftAuthenticatorAuthenticationMethodConfigurationRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.extensions.MicrosoftAuthenticatorAuthenticationMethodConfigurationRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequestBuilder includeTargets() {
        return new MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("includeTargets"), getClient(), null);
    }

    public IMicrosoftAuthenticatorAuthenticationMethodTargetRequestBuilder includeTargets(final String id) {
        return new MicrosoftAuthenticatorAuthenticationMethodTargetRequestBuilder(getRequestUrlWithAdditionalSegment("includeTargets") + "/" + id, getClient(), null);
    }
}
