/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ComplianceManagementPartner;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ComplianceManagementPartnerCollectionPage;
import com.microsoft.graph.requests.extensions.ComplianceManagementPartnerCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ComplianceManagementPartnerCollectionResponse;
import com.microsoft.graph.requests.extensions.ComplianceManagementPartnerRequestBuilder;
import com.microsoft.graph.requests.extensions.IComplianceManagementPartnerCollectionPage;
import com.microsoft.graph.requests.extensions.IComplianceManagementPartnerCollectionRequest;
import java.util.List;

public class ComplianceManagementPartnerCollectionRequest
extends BaseCollectionRequest<ComplianceManagementPartnerCollectionResponse, IComplianceManagementPartnerCollectionPage>
implements IComplianceManagementPartnerCollectionRequest {
    public ComplianceManagementPartnerCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ComplianceManagementPartnerCollectionResponse.class, IComplianceManagementPartnerCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IComplianceManagementPartnerCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ComplianceManagementPartnerCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IComplianceManagementPartnerCollectionPage get() throws ClientException {
        ComplianceManagementPartnerCollectionResponse response = (ComplianceManagementPartnerCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ComplianceManagementPartner newComplianceManagementPartner, ICallback<? super ComplianceManagementPartner> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ComplianceManagementPartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newComplianceManagementPartner, callback);
    }

    @Override
    public ComplianceManagementPartner post(ComplianceManagementPartner newComplianceManagementPartner) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ComplianceManagementPartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newComplianceManagementPartner);
    }

    @Override
    public IComplianceManagementPartnerCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IComplianceManagementPartnerCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IComplianceManagementPartnerCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IComplianceManagementPartnerCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IComplianceManagementPartnerCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IComplianceManagementPartnerCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IComplianceManagementPartnerCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IComplianceManagementPartnerCollectionPage buildFromResponse(ComplianceManagementPartnerCollectionResponse response) {
        ComplianceManagementPartnerCollectionRequestBuilder builder = response.nextLink != null ? new ComplianceManagementPartnerCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ComplianceManagementPartnerCollectionPage page = new ComplianceManagementPartnerCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

