/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.AgreementFileVersion;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AgreementFileVersionCollectionPage;
import com.microsoft.graph.requests.extensions.AgreementFileVersionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementFileVersionCollectionResponse;
import com.microsoft.graph.requests.extensions.AgreementFileVersionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementFileVersionCollectionPage;
import com.microsoft.graph.requests.extensions.IAgreementFileVersionCollectionRequest;
import java.util.List;

public class AgreementFileVersionCollectionRequest
extends BaseCollectionRequest<AgreementFileVersionCollectionResponse, IAgreementFileVersionCollectionPage>
implements IAgreementFileVersionCollectionRequest {
    public AgreementFileVersionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementFileVersionCollectionResponse.class, IAgreementFileVersionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IAgreementFileVersionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(AgreementFileVersionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAgreementFileVersionCollectionPage get() throws ClientException {
        AgreementFileVersionCollectionResponse response = (AgreementFileVersionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(AgreementFileVersion newAgreementFileVersion, ICallback<? super AgreementFileVersion> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new AgreementFileVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAgreementFileVersion, callback);
    }

    @Override
    public AgreementFileVersion post(AgreementFileVersion newAgreementFileVersion) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AgreementFileVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAgreementFileVersion);
    }

    @Override
    public IAgreementFileVersionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IAgreementFileVersionCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IAgreementFileVersionCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IAgreementFileVersionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAgreementFileVersionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IAgreementFileVersionCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IAgreementFileVersionCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IAgreementFileVersionCollectionPage buildFromResponse(AgreementFileVersionCollectionResponse response) {
        AgreementFileVersionCollectionRequestBuilder builder = response.nextLink != null ? new AgreementFileVersionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AgreementFileVersionCollectionPage page = new AgreementFileVersionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

