/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PrintJob;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintJobCollectionPage;
import com.microsoft.graph.requests.extensions.IPrintJobCollectionRequest;
import com.microsoft.graph.requests.extensions.PrintJobCollectionPage;
import com.microsoft.graph.requests.extensions.PrintJobCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintJobCollectionResponse;
import com.microsoft.graph.requests.extensions.PrintJobRequestBuilder;
import java.util.List;

public class PrintJobCollectionRequest
extends BaseCollectionRequest<PrintJobCollectionResponse, IPrintJobCollectionPage>
implements IPrintJobCollectionRequest {
    public PrintJobCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintJobCollectionResponse.class, IPrintJobCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrintJobCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrintJobCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrintJobCollectionPage get() throws ClientException {
        PrintJobCollectionResponse response = (PrintJobCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PrintJob newPrintJob, ICallback<? super PrintJob> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PrintJobRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintJob, callback);
    }

    @Override
    public PrintJob post(PrintJob newPrintJob) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintJobRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintJob);
    }

    @Override
    public IPrintJobCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPrintJobCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPrintJobCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrintJobCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintJobCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPrintJobCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPrintJobCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPrintJobCollectionPage buildFromResponse(PrintJobCollectionResponse response) {
        PrintJobCollectionRequestBuilder builder = response.nextLink != null ? new PrintJobCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrintJobCollectionPage page = new PrintJobCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

