/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PrintServiceEndpoint;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintServiceEndpointCollectionPage;
import com.microsoft.graph.requests.extensions.IPrintServiceEndpointCollectionRequest;
import com.microsoft.graph.requests.extensions.PrintServiceEndpointCollectionPage;
import com.microsoft.graph.requests.extensions.PrintServiceEndpointCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintServiceEndpointCollectionResponse;
import com.microsoft.graph.requests.extensions.PrintServiceEndpointRequestBuilder;
import java.util.List;

public class PrintServiceEndpointCollectionRequest
extends BaseCollectionRequest<PrintServiceEndpointCollectionResponse, IPrintServiceEndpointCollectionPage>
implements IPrintServiceEndpointCollectionRequest {
    public PrintServiceEndpointCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintServiceEndpointCollectionResponse.class, IPrintServiceEndpointCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrintServiceEndpointCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrintServiceEndpointCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrintServiceEndpointCollectionPage get() throws ClientException {
        PrintServiceEndpointCollectionResponse response = (PrintServiceEndpointCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PrintServiceEndpoint newPrintServiceEndpoint, ICallback<? super PrintServiceEndpoint> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PrintServiceEndpointRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintServiceEndpoint, callback);
    }

    @Override
    public PrintServiceEndpoint post(PrintServiceEndpoint newPrintServiceEndpoint) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintServiceEndpointRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintServiceEndpoint);
    }

    @Override
    public IPrintServiceEndpointCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPrintServiceEndpointCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPrintServiceEndpointCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrintServiceEndpointCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintServiceEndpointCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPrintServiceEndpointCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPrintServiceEndpointCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPrintServiceEndpointCollectionPage buildFromResponse(PrintServiceEndpointCollectionResponse response) {
        PrintServiceEndpointCollectionRequestBuilder builder = response.nextLink != null ? new PrintServiceEndpointCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrintServiceEndpointCollectionPage page = new PrintServiceEndpointCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

