/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.extensions.PrinterShare;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrinterShareCollectionPage;
import com.microsoft.graph.requests.extensions.IPrinterShareCollectionReferenceRequest;
import com.microsoft.graph.requests.extensions.PrinterShareCollectionResponse;
import com.microsoft.graph.requests.extensions.PrinterShareWithReferenceRequestBuilder;
import java.util.List;

public class PrinterShareCollectionReferenceRequest
extends BaseCollectionRequest<PrinterShareCollectionResponse, IPrinterShareCollectionPage>
implements IPrinterShareCollectionReferenceRequest {
    public PrinterShareCollectionReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrinterShareCollectionResponse.class, IPrinterShareCollectionPage.class);
    }

    @Override
    public void post(PrinterShare newPrinterShare, ICallback<? super PrinterShare> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/print/shares/" + newPrinterShare.id);
        new PrinterShareWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrinterShare, body, callback);
    }

    @Override
    public PrinterShare post(PrinterShare newPrinterShare) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/print/shares/" + newPrinterShare.id);
        return new PrinterShareWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrinterShare, body);
    }

    public IPrinterShareCollectionReferenceRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IPrinterShareCollectionReferenceRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IPrinterShareCollectionReferenceRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrinterShareCollectionReferenceRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrinterShareCollectionReferenceRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }
}

