/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITokenIssuancePolicyCollectionPage;
import com.microsoft.graph.requests.extensions.ITokenIssuancePolicyCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.ITokenIssuancePolicyCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.TokenIssuancePolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.TokenIssuancePolicyCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.TokenIssuancePolicyCollectionWithReferencesRequestBuilder;
import java.util.List;

public class TokenIssuancePolicyCollectionWithReferencesRequest
extends BaseCollectionRequest<TokenIssuancePolicyCollectionResponse, ITokenIssuancePolicyCollectionPage>
implements ITokenIssuancePolicyCollectionWithReferencesRequest {
    public TokenIssuancePolicyCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TokenIssuancePolicyCollectionResponse.class, ITokenIssuancePolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ITokenIssuancePolicyCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TokenIssuancePolicyCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITokenIssuancePolicyCollectionWithReferencesPage get() throws ClientException {
        TokenIssuancePolicyCollectionResponse response = (TokenIssuancePolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public ITokenIssuancePolicyCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public ITokenIssuancePolicyCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public ITokenIssuancePolicyCollectionWithReferencesRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ITokenIssuancePolicyCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITokenIssuancePolicyCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ITokenIssuancePolicyCollectionWithReferencesPage buildFromResponse(TokenIssuancePolicyCollectionResponse response) {
        TokenIssuancePolicyCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new TokenIssuancePolicyCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TokenIssuancePolicyCollectionWithReferencesPage page = new TokenIssuancePolicyCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

