/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WindowsHelloForBusinessAuthenticationMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWindowsHelloForBusinessAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.extensions.IWindowsHelloForBusinessAuthenticationMethodCollectionRequest;
import com.microsoft.graph.requests.extensions.WindowsHelloForBusinessAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.extensions.WindowsHelloForBusinessAuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WindowsHelloForBusinessAuthenticationMethodCollectionResponse;
import com.microsoft.graph.requests.extensions.WindowsHelloForBusinessAuthenticationMethodRequestBuilder;
import java.util.List;

public class WindowsHelloForBusinessAuthenticationMethodCollectionRequest
extends BaseCollectionRequest<WindowsHelloForBusinessAuthenticationMethodCollectionResponse, IWindowsHelloForBusinessAuthenticationMethodCollectionPage>
implements IWindowsHelloForBusinessAuthenticationMethodCollectionRequest {
    public WindowsHelloForBusinessAuthenticationMethodCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsHelloForBusinessAuthenticationMethodCollectionResponse.class, IWindowsHelloForBusinessAuthenticationMethodCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IWindowsHelloForBusinessAuthenticationMethodCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WindowsHelloForBusinessAuthenticationMethodCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWindowsHelloForBusinessAuthenticationMethodCollectionPage get() throws ClientException {
        WindowsHelloForBusinessAuthenticationMethodCollectionResponse response = (WindowsHelloForBusinessAuthenticationMethodCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WindowsHelloForBusinessAuthenticationMethod newWindowsHelloForBusinessAuthenticationMethod, ICallback<? super WindowsHelloForBusinessAuthenticationMethod> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WindowsHelloForBusinessAuthenticationMethodRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWindowsHelloForBusinessAuthenticationMethod, callback);
    }

    @Override
    public WindowsHelloForBusinessAuthenticationMethod post(WindowsHelloForBusinessAuthenticationMethod newWindowsHelloForBusinessAuthenticationMethod) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WindowsHelloForBusinessAuthenticationMethodRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWindowsHelloForBusinessAuthenticationMethod);
    }

    @Override
    public IWindowsHelloForBusinessAuthenticationMethodCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWindowsHelloForBusinessAuthenticationMethodCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IWindowsHelloForBusinessAuthenticationMethodCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IWindowsHelloForBusinessAuthenticationMethodCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWindowsHelloForBusinessAuthenticationMethodCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IWindowsHelloForBusinessAuthenticationMethodCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IWindowsHelloForBusinessAuthenticationMethodCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IWindowsHelloForBusinessAuthenticationMethodCollectionPage buildFromResponse(WindowsHelloForBusinessAuthenticationMethodCollectionResponse response) {
        WindowsHelloForBusinessAuthenticationMethodCollectionRequestBuilder builder = response.nextLink != null ? new WindowsHelloForBusinessAuthenticationMethodCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WindowsHelloForBusinessAuthenticationMethodCollectionPage page = new WindowsHelloForBusinessAuthenticationMethodCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

