// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AppScope;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.UnifiedRoleDefinition;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Assignment.
 */
public class UnifiedRoleAssignment extends Entity implements IJsonBackedObject {


    /**
     * The App Scope Id.
     * Id of the app specific scope when the assignment scope is app specific. The scope of an assignment determines the set of resources for which the principal has been granted access. Directory scopes are shared scopes stored in the directory that are understood by multiple applications. Use '/' for tenant-wide scope. App scopes are scopes that are defined and understood by this application only.
     */
    @SerializedName(value = "appScopeId", alternate = {"AppScopeId"})
    @Expose
	@Nullable
    public String appScopeId;

    /**
     * The Condition.
     * 
     */
    @SerializedName(value = "condition", alternate = {"Condition"})
    @Expose
	@Nullable
    public String condition;

    /**
     * The Directory Scope Id.
     * Id of the directory object representing the scope of the assignment. The scope of an assignment determines the set of resources for which the principal has been granted access. Directory scopes are shared scopes stored in the directory that are understood by multiple applications. App scopes are scopes that are defined and understood by this application only.
     */
    @SerializedName(value = "directoryScopeId", alternate = {"DirectoryScopeId"})
    @Expose
	@Nullable
    public String directoryScopeId;

    /**
     * The Principal Id.
     * Objectid of the principal to which the assignment is granted.
     */
    @SerializedName(value = "principalId", alternate = {"PrincipalId"})
    @Expose
	@Nullable
    public String principalId;

    /**
     * The Role Definition Id.
     * ID of the unifiedRoleDefinition the assignment is for. Read only.
     */
    @SerializedName(value = "roleDefinitionId", alternate = {"RoleDefinitionId"})
    @Expose
	@Nullable
    public String roleDefinitionId;

    /**
     * The App Scope.
     * 
     */
    @SerializedName(value = "appScope", alternate = {"AppScope"})
    @Expose
	@Nullable
    public AppScope appScope;

    /**
     * The Directory Scope.
     * 
     */
    @SerializedName(value = "directoryScope", alternate = {"DirectoryScope"})
    @Expose
	@Nullable
    public DirectoryObject directoryScope;

    /**
     * The Principal.
     * 
     */
    @SerializedName(value = "principal", alternate = {"Principal"})
    @Expose
	@Nullable
    public DirectoryObject principal;

    /**
     * The Role Definition.
     * 
     */
    @SerializedName(value = "roleDefinition", alternate = {"RoleDefinition"})
    @Expose
	@Nullable
    public UnifiedRoleDefinition roleDefinition;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
