// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ConsentRequestFilterByCurrentUserOptions;
import com.microsoft.graph.models.AppConsentRequest;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AppConsentRequestFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.requests.AppConsentRequestFilterByCurrentUserCollectionRequest;
import com.microsoft.graph.requests.AppConsentRequestFilterByCurrentUserCollectionResponse;
import com.microsoft.graph.models.AppConsentRequestFilterByCurrentUserParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the App Consent Request Filter By Current User Collection Request Builder.
 */
public class AppConsentRequestFilterByCurrentUserCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<AppConsentRequest, AppConsentRequestFilterByCurrentUserCollectionRequestBuilder, AppConsentRequestFilterByCurrentUserCollectionResponse, AppConsentRequestFilterByCurrentUserCollectionPage, AppConsentRequestFilterByCurrentUserCollectionRequest> {

    /**
     * The request builder for this collection of AppConsentRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AppConsentRequestFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AppConsentRequestFilterByCurrentUserCollectionRequestBuilder.class, AppConsentRequestFilterByCurrentUserCollectionRequest.class);
    }
    /**
     * The request builder for this collection of AppConsentRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public AppConsentRequestFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final AppConsentRequestFilterByCurrentUserParameterSet parameters) {
        super(requestUrl, client, requestOptions, AppConsentRequestFilterByCurrentUserCollectionRequestBuilder.class, AppConsentRequestFilterByCurrentUserCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AppConsentRequestFilterByCurrentUserCollectionRequest instance
     */
    @Override
    @Nonnull
    public AppConsentRequestFilterByCurrentUserCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final AppConsentRequestFilterByCurrentUserCollectionRequest request = super.buildRequest(requestOptions);
          for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
            request.addFunctionOption(option);
      }
        return request;
    }
}
