// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookPivotTable;
import com.microsoft.graph.requests.WorkbookWorksheetRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Pivot Table Request.
 */
public class WorkbookPivotTableRequest extends BaseRequest<WorkbookPivotTable> {
	
    /**
     * The request for the WorkbookPivotTable
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookPivotTableRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookPivotTable.class);
    }

    /**
     * Gets the WorkbookPivotTable from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookPivotTable> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookPivotTable from the service
     *
     * @return the WorkbookPivotTable from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookPivotTable get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookPivotTable> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookPivotTable delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookPivotTable with a source
     *
     * @param sourceWorkbookPivotTable the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookPivotTable> patchAsync(@Nonnull final WorkbookPivotTable sourceWorkbookPivotTable) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookPivotTable);
    }

    /**
     * Patches this WorkbookPivotTable with a source
     *
     * @param sourceWorkbookPivotTable the source object with updates
     * @return the updated WorkbookPivotTable
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookPivotTable patch(@Nonnull final WorkbookPivotTable sourceWorkbookPivotTable) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookPivotTable);
    }

    /**
     * Creates a WorkbookPivotTable with a new object
     *
     * @param newWorkbookPivotTable the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookPivotTable> postAsync(@Nonnull final WorkbookPivotTable newWorkbookPivotTable) {
        return sendAsync(HttpMethod.POST, newWorkbookPivotTable);
    }

    /**
     * Creates a WorkbookPivotTable with a new object
     *
     * @param newWorkbookPivotTable the new object to create
     * @return the created WorkbookPivotTable
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookPivotTable post(@Nonnull final WorkbookPivotTable newWorkbookPivotTable) throws ClientException {
        return send(HttpMethod.POST, newWorkbookPivotTable);
    }

    /**
     * Creates a WorkbookPivotTable with a new object
     *
     * @param newWorkbookPivotTable the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookPivotTable> putAsync(@Nonnull final WorkbookPivotTable newWorkbookPivotTable) {
        return sendAsync(HttpMethod.PUT, newWorkbookPivotTable);
    }

    /**
     * Creates a WorkbookPivotTable with a new object
     *
     * @param newWorkbookPivotTable the object to create/update
     * @return the created WorkbookPivotTable
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookPivotTable put(@Nonnull final WorkbookPivotTable newWorkbookPivotTable) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookPivotTable);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookPivotTableRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookPivotTableRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

