// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceCompliancePolicyDeviceStateSummary;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Compliance Policy Device State Summary Request.
 */
public class DeviceCompliancePolicyDeviceStateSummaryRequest extends BaseRequest<DeviceCompliancePolicyDeviceStateSummary> {
	
    /**
     * The request for the DeviceCompliancePolicyDeviceStateSummary
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceCompliancePolicyDeviceStateSummaryRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceCompliancePolicyDeviceStateSummary.class);
    }

    /**
     * Gets the DeviceCompliancePolicyDeviceStateSummary from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceCompliancePolicyDeviceStateSummary> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeviceCompliancePolicyDeviceStateSummary from the service
     *
     * @return the DeviceCompliancePolicyDeviceStateSummary from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceCompliancePolicyDeviceStateSummary get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceCompliancePolicyDeviceStateSummary> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeviceCompliancePolicyDeviceStateSummary delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceCompliancePolicyDeviceStateSummary with a source
     *
     * @param sourceDeviceCompliancePolicyDeviceStateSummary the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceCompliancePolicyDeviceStateSummary> patchAsync(@Nonnull final DeviceCompliancePolicyDeviceStateSummary sourceDeviceCompliancePolicyDeviceStateSummary) {
        return sendAsync(HttpMethod.PATCH, sourceDeviceCompliancePolicyDeviceStateSummary);
    }

    /**
     * Patches this DeviceCompliancePolicyDeviceStateSummary with a source
     *
     * @param sourceDeviceCompliancePolicyDeviceStateSummary the source object with updates
     * @return the updated DeviceCompliancePolicyDeviceStateSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceCompliancePolicyDeviceStateSummary patch(@Nonnull final DeviceCompliancePolicyDeviceStateSummary sourceDeviceCompliancePolicyDeviceStateSummary) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceCompliancePolicyDeviceStateSummary);
    }

    /**
     * Creates a DeviceCompliancePolicyDeviceStateSummary with a new object
     *
     * @param newDeviceCompliancePolicyDeviceStateSummary the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceCompliancePolicyDeviceStateSummary> postAsync(@Nonnull final DeviceCompliancePolicyDeviceStateSummary newDeviceCompliancePolicyDeviceStateSummary) {
        return sendAsync(HttpMethod.POST, newDeviceCompliancePolicyDeviceStateSummary);
    }

    /**
     * Creates a DeviceCompliancePolicyDeviceStateSummary with a new object
     *
     * @param newDeviceCompliancePolicyDeviceStateSummary the new object to create
     * @return the created DeviceCompliancePolicyDeviceStateSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceCompliancePolicyDeviceStateSummary post(@Nonnull final DeviceCompliancePolicyDeviceStateSummary newDeviceCompliancePolicyDeviceStateSummary) throws ClientException {
        return send(HttpMethod.POST, newDeviceCompliancePolicyDeviceStateSummary);
    }

    /**
     * Creates a DeviceCompliancePolicyDeviceStateSummary with a new object
     *
     * @param newDeviceCompliancePolicyDeviceStateSummary the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceCompliancePolicyDeviceStateSummary> putAsync(@Nonnull final DeviceCompliancePolicyDeviceStateSummary newDeviceCompliancePolicyDeviceStateSummary) {
        return sendAsync(HttpMethod.PUT, newDeviceCompliancePolicyDeviceStateSummary);
    }

    /**
     * Creates a DeviceCompliancePolicyDeviceStateSummary with a new object
     *
     * @param newDeviceCompliancePolicyDeviceStateSummary the object to create/update
     * @return the created DeviceCompliancePolicyDeviceStateSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceCompliancePolicyDeviceStateSummary put(@Nonnull final DeviceCompliancePolicyDeviceStateSummary newDeviceCompliancePolicyDeviceStateSummary) throws ClientException {
        return send(HttpMethod.PUT, newDeviceCompliancePolicyDeviceStateSummary);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeviceCompliancePolicyDeviceStateSummaryRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeviceCompliancePolicyDeviceStateSummaryRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

