// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ItemReference;
import com.microsoft.graph.models.ContentTypeOrder;
import com.microsoft.graph.models.ColumnLink;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.ColumnLinkCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Content Type.
 */
public class ContentType extends Entity implements IJsonBackedObject {


    /**
     * The Description.
     * The descriptive text for the item.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Group.
     * The name of the group this content type belongs to. Helps organize related content types.
     */
    @SerializedName(value = "group", alternate = {"Group"})
    @Expose
	@Nullable
    public String group;

    /**
     * The Hidden.
     * Indicates whether the content type is hidden in the list's 'New' menu.
     */
    @SerializedName(value = "hidden", alternate = {"Hidden"})
    @Expose
	@Nullable
    public Boolean hidden;

    /**
     * The Inherited From.
     * If this content type is inherited from another scope (like a site), provides a reference to the item where the content type is defined.
     */
    @SerializedName(value = "inheritedFrom", alternate = {"InheritedFrom"})
    @Expose
	@Nullable
    public ItemReference inheritedFrom;

    /**
     * The Name.
     * The name of the content type.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Order.
     * Specifies the order in which the content type appears in the selection UI.
     */
    @SerializedName(value = "order", alternate = {"Order"})
    @Expose
	@Nullable
    public ContentTypeOrder order;

    /**
     * The Parent Id.
     * The unique identifier of the content type.
     */
    @SerializedName(value = "parentId", alternate = {"ParentId"})
    @Expose
	@Nullable
    public String parentId;

    /**
     * The Read Only.
     * If true, the content type cannot be modified unless this value is first set to false.
     */
    @SerializedName(value = "readOnly", alternate = {"ReadOnly"})
    @Expose
	@Nullable
    public Boolean readOnly;

    /**
     * The Sealed.
     * If true, the content type cannot be modified by users or through push-down operations. Only site collection administrators can seal or unseal content types.
     */
    @SerializedName(value = "sealed", alternate = {"Sealed"})
    @Expose
	@Nullable
    public Boolean sealed;

    /**
     * The Column Links.
     * The collection of columns that are required by this content type
     */
    @SerializedName(value = "columnLinks", alternate = {"ColumnLinks"})
    @Expose
	@Nullable
    public ColumnLinkCollectionPage columnLinks;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("columnLinks")) {
            columnLinks = serializer.deserializeObject(json.get("columnLinks"), ColumnLinkCollectionPage.class);
        }
    }
}
