// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.MediaDirection;
import com.microsoft.graph.models.Modality;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Media Stream.
 */
public class MediaStream implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Direction.
     * The direction. The possible values are inactive, sendOnly, receiveOnly, sendReceive.
     */
    @SerializedName(value = "direction", alternate = {"Direction"})
    @Expose
	@Nullable
    public MediaDirection direction;

    /**
     * The Label.
     * The media stream label.
     */
    @SerializedName(value = "label", alternate = {"Label"})
    @Expose
	@Nullable
    public String label;

    /**
     * The Media Type.
     * The media type. The possible value are unknown, audio, video, videoBasedScreenSharing, data.
     */
    @SerializedName(value = "mediaType", alternate = {"MediaType"})
    @Expose
	@Nullable
    public Modality mediaType;

    /**
     * The Server Muted.
     * Indicates whether the media is muted by the server.
     */
    @SerializedName(value = "serverMuted", alternate = {"ServerMuted"})
    @Expose
	@Nullable
    public Boolean serverMuted;

    /**
     * The Source Id.
     * The source ID.
     */
    @SerializedName(value = "sourceId", alternate = {"SourceId"})
    @Expose
	@Nullable
    public String sourceId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
