// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.RolePermission;
import com.microsoft.graph.models.RoleAssignment;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.RoleAssignmentCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Role Definition.
 */
public class RoleDefinition extends Entity implements IJsonBackedObject {


    /**
     * The Description.
     * Description of the Role definition.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * Display Name of the Role definition.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Is Built In.
     * Type of Role. Set to True if it is built-in, or set to False if it is a custom role definition.
     */
    @SerializedName(value = "isBuiltIn", alternate = {"IsBuiltIn"})
    @Expose
	@Nullable
    public Boolean isBuiltIn;

    /**
     * The Role Permissions.
     * List of Role Permissions this role is allowed to perform. These must match the actionName that is defined as part of the rolePermission.
     */
    @SerializedName(value = "rolePermissions", alternate = {"RolePermissions"})
    @Expose
	@Nullable
    public java.util.List<RolePermission> rolePermissions;

    /**
     * The Role Assignments.
     * List of Role assignments for this role definition.
     */
    @SerializedName(value = "roleAssignments", alternate = {"RoleAssignments"})
    @Expose
	@Nullable
    public RoleAssignmentCollectionPage roleAssignments;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("roleAssignments")) {
            roleAssignments = serializer.deserializeObject(json.get("roleAssignments"), RoleAssignmentCollectionPage.class);
        }
    }
}
