// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AgreementFileLocalization;
import com.microsoft.graph.requests.AgreementFileVersionCollectionRequestBuilder;
import com.microsoft.graph.requests.AgreementFileVersionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement File Localization Request.
 */
public class AgreementFileLocalizationRequest extends BaseRequest<AgreementFileLocalization> {
	
    /**
     * The request for the AgreementFileLocalization
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AgreementFileLocalizationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementFileLocalization.class);
    }

    /**
     * Gets the AgreementFileLocalization from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFileLocalization> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AgreementFileLocalization from the service
     *
     * @return the AgreementFileLocalization from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementFileLocalization get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFileLocalization> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AgreementFileLocalization delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AgreementFileLocalization with a source
     *
     * @param sourceAgreementFileLocalization the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFileLocalization> patchAsync(@Nonnull final AgreementFileLocalization sourceAgreementFileLocalization) {
        return sendAsync(HttpMethod.PATCH, sourceAgreementFileLocalization);
    }

    /**
     * Patches this AgreementFileLocalization with a source
     *
     * @param sourceAgreementFileLocalization the source object with updates
     * @return the updated AgreementFileLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementFileLocalization patch(@Nonnull final AgreementFileLocalization sourceAgreementFileLocalization) throws ClientException {
        return send(HttpMethod.PATCH, sourceAgreementFileLocalization);
    }

    /**
     * Creates a AgreementFileLocalization with a new object
     *
     * @param newAgreementFileLocalization the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFileLocalization> postAsync(@Nonnull final AgreementFileLocalization newAgreementFileLocalization) {
        return sendAsync(HttpMethod.POST, newAgreementFileLocalization);
    }

    /**
     * Creates a AgreementFileLocalization with a new object
     *
     * @param newAgreementFileLocalization the new object to create
     * @return the created AgreementFileLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementFileLocalization post(@Nonnull final AgreementFileLocalization newAgreementFileLocalization) throws ClientException {
        return send(HttpMethod.POST, newAgreementFileLocalization);
    }

    /**
     * Creates a AgreementFileLocalization with a new object
     *
     * @param newAgreementFileLocalization the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFileLocalization> putAsync(@Nonnull final AgreementFileLocalization newAgreementFileLocalization) {
        return sendAsync(HttpMethod.PUT, newAgreementFileLocalization);
    }

    /**
     * Creates a AgreementFileLocalization with a new object
     *
     * @param newAgreementFileLocalization the object to create/update
     * @return the created AgreementFileLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementFileLocalization put(@Nonnull final AgreementFileLocalization newAgreementFileLocalization) throws ClientException {
        return send(HttpMethod.PUT, newAgreementFileLocalization);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AgreementFileLocalizationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AgreementFileLocalizationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

