// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.EducationAssignmentSetUpResourcesFolderRequest;
import com.microsoft.graph.models.EducationAssignment;
import com.microsoft.graph.http.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Assignment Set Up Resources Folder Request Builder.
 */
public class EducationAssignmentSetUpResourcesFolderRequestBuilder extends BaseFunctionRequestBuilder<EducationAssignment> {

    /**
     * The request builder for this EducationAssignmentSetUpResourcesFolder
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationAssignmentSetUpResourcesFolderRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the EducationAssignmentSetUpResourcesFolderRequest
     *
     * @param requestOptions the options for the request
     * @return the EducationAssignmentSetUpResourcesFolderRequest instance
     */
    @Nonnull
    public EducationAssignmentSetUpResourcesFolderRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the EducationAssignmentSetUpResourcesFolderRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the EducationAssignmentSetUpResourcesFolderRequest instance
     */
    @Nonnull
    public EducationAssignmentSetUpResourcesFolderRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final EducationAssignmentSetUpResourcesFolderRequest request = new EducationAssignmentSetUpResourcesFolderRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
