/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Channel;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ChannelCollectionPage;
import com.microsoft.graph.requests.ChannelCollectionRequestBuilder;
import com.microsoft.graph.requests.ChannelCollectionResponse;
import com.microsoft.graph.requests.ChannelRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChannelCollectionRequest
extends BaseEntityCollectionRequest<Channel, ChannelCollectionResponse, ChannelCollectionPage> {
    public ChannelCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChannelCollectionResponse.class, ChannelCollectionPage.class, ChannelCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Channel> postAsync(@Nonnull Channel newChannel) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ChannelRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newChannel);
    }

    @Nonnull
    public Channel post(@Nonnull Channel newChannel) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ChannelRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newChannel);
    }

    @Nonnull
    public ChannelCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ChannelCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ChannelCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ChannelCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ChannelCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ChannelCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ChannelCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ChannelCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ChannelCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

