// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessReviewScheduleDefinitionFilterByCurrentUserOptions;
import com.microsoft.graph.models.AccessReviewScheduleDefinition;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.requests.AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequest;
import com.microsoft.graph.requests.AccessReviewScheduleDefinitionFilterByCurrentUserCollectionResponse;
import com.microsoft.graph.models.AccessReviewScheduleDefinitionFilterByCurrentUserParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Review Schedule Definition Filter By Current User Collection Request Builder.
 */
public class AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<AccessReviewScheduleDefinition, AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequestBuilder, AccessReviewScheduleDefinitionFilterByCurrentUserCollectionResponse, AccessReviewScheduleDefinitionFilterByCurrentUserCollectionPage, AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequest> {

    /**
     * The request builder for this collection of AccessReviewScheduleDefinition
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequestBuilder.class, AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequest.class);
    }
    /**
     * The request builder for this collection of AccessReviewScheduleDefinition
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final AccessReviewScheduleDefinitionFilterByCurrentUserParameterSet parameters) {
        super(requestUrl, client, requestOptions, AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequestBuilder.class, AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequest instance
     */
    @Override
    @Nonnull
    public AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final AccessReviewScheduleDefinitionFilterByCurrentUserCollectionRequest request = super.buildRequest(requestOptions);
          for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
            request.addFunctionOption(option);
      }
        return request;
    }
}
