// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ItemAnalytics;
import com.microsoft.graph.requests.ItemActivityStatWithReferenceRequestBuilder;
import com.microsoft.graph.requests.ItemActivityStatCollectionRequestBuilder;
import com.microsoft.graph.requests.ItemActivityStatRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Item Analytics Request.
 */
public class ItemAnalyticsRequest extends BaseRequest<ItemAnalytics> {
	
    /**
     * The request for the ItemAnalytics
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ItemAnalyticsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemAnalytics.class);
    }

    /**
     * Gets the ItemAnalytics from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemAnalytics> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ItemAnalytics from the service
     *
     * @return the ItemAnalytics from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ItemAnalytics get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemAnalytics> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ItemAnalytics delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ItemAnalytics with a source
     *
     * @param sourceItemAnalytics the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemAnalytics> patchAsync(@Nonnull final ItemAnalytics sourceItemAnalytics) {
        return sendAsync(HttpMethod.PATCH, sourceItemAnalytics);
    }

    /**
     * Patches this ItemAnalytics with a source
     *
     * @param sourceItemAnalytics the source object with updates
     * @return the updated ItemAnalytics
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ItemAnalytics patch(@Nonnull final ItemAnalytics sourceItemAnalytics) throws ClientException {
        return send(HttpMethod.PATCH, sourceItemAnalytics);
    }

    /**
     * Creates a ItemAnalytics with a new object
     *
     * @param newItemAnalytics the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemAnalytics> postAsync(@Nonnull final ItemAnalytics newItemAnalytics) {
        return sendAsync(HttpMethod.POST, newItemAnalytics);
    }

    /**
     * Creates a ItemAnalytics with a new object
     *
     * @param newItemAnalytics the new object to create
     * @return the created ItemAnalytics
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ItemAnalytics post(@Nonnull final ItemAnalytics newItemAnalytics) throws ClientException {
        return send(HttpMethod.POST, newItemAnalytics);
    }

    /**
     * Creates a ItemAnalytics with a new object
     *
     * @param newItemAnalytics the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemAnalytics> putAsync(@Nonnull final ItemAnalytics newItemAnalytics) {
        return sendAsync(HttpMethod.PUT, newItemAnalytics);
    }

    /**
     * Creates a ItemAnalytics with a new object
     *
     * @param newItemAnalytics the object to create/update
     * @return the created ItemAnalytics
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ItemAnalytics put(@Nonnull final ItemAnalytics newItemAnalytics) throws ClientException {
        return send(HttpMethod.PUT, newItemAnalytics);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ItemAnalyticsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ItemAnalyticsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

