// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.callrecords.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.callrecords.models.CallRecord;
import com.microsoft.graph.callrecords.requests.SessionCollectionRequestBuilder;
import com.microsoft.graph.callrecords.requests.SessionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Record Request.
 */
public class CallRecordRequest extends BaseRequest<CallRecord> {
	
    /**
     * The request for the CallRecord
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CallRecordRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CallRecord.class);
    }

    /**
     * Gets the CallRecord from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CallRecord> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CallRecord from the service
     *
     * @return the CallRecord from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CallRecord get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CallRecord> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CallRecord delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CallRecord with a source
     *
     * @param sourceCallRecord the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CallRecord> patchAsync(@Nonnull final CallRecord sourceCallRecord) {
        return sendAsync(HttpMethod.PATCH, sourceCallRecord);
    }

    /**
     * Patches this CallRecord with a source
     *
     * @param sourceCallRecord the source object with updates
     * @return the updated CallRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CallRecord patch(@Nonnull final CallRecord sourceCallRecord) throws ClientException {
        return send(HttpMethod.PATCH, sourceCallRecord);
    }

    /**
     * Creates a CallRecord with a new object
     *
     * @param newCallRecord the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CallRecord> postAsync(@Nonnull final CallRecord newCallRecord) {
        return sendAsync(HttpMethod.POST, newCallRecord);
    }

    /**
     * Creates a CallRecord with a new object
     *
     * @param newCallRecord the new object to create
     * @return the created CallRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CallRecord post(@Nonnull final CallRecord newCallRecord) throws ClientException {
        return send(HttpMethod.POST, newCallRecord);
    }

    /**
     * Creates a CallRecord with a new object
     *
     * @param newCallRecord the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CallRecord> putAsync(@Nonnull final CallRecord newCallRecord) {
        return sendAsync(HttpMethod.PUT, newCallRecord);
    }

    /**
     * Creates a CallRecord with a new object
     *
     * @param newCallRecord the object to create/update
     * @return the created CallRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CallRecord put(@Nonnull final CallRecord newCallRecord) throws ClientException {
        return send(HttpMethod.PUT, newCallRecord);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CallRecordRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CallRecordRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

