// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Filter Apply Dynamic Filter Parameter Set.
 */
public class WorkbookFilterApplyDynamicFilterParameterSet {
    /**
     * The criteria.
     * 
     */
    @SerializedName(value = "criteria", alternate = {"Criteria"})
    @Expose
	@Nullable
    public String criteria;


    /**
     * Instiaciates a new WorkbookFilterApplyDynamicFilterParameterSet
     */
    public WorkbookFilterApplyDynamicFilterParameterSet() {}
    /**
     * Instiaciates a new WorkbookFilterApplyDynamicFilterParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFilterApplyDynamicFilterParameterSet(@Nonnull final WorkbookFilterApplyDynamicFilterParameterSetBuilder builder) {
        this.criteria = builder.criteria;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFilterApplyDynamicFilterParameterSetBuilder newBuilder() {
        return new WorkbookFilterApplyDynamicFilterParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFilterApplyDynamicFilterParameterSet
     */
    public static final class WorkbookFilterApplyDynamicFilterParameterSetBuilder {
        /**
         * The criteria parameter value
         */
        @Nullable
        protected String criteria;
        /**
         * Sets the Criteria
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFilterApplyDynamicFilterParameterSetBuilder withCriteria(@Nullable final String val) {
            this.criteria = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFilterApplyDynamicFilterParameterSetBuilder
         */
        @Nullable
        protected WorkbookFilterApplyDynamicFilterParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFilterApplyDynamicFilterParameterSet build() {
            return new WorkbookFilterApplyDynamicFilterParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.criteria != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("criteria", criteria));
        }
        return result;
    }
}
