// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.BookingAppointment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Booking Appointment Request.
 */
public class BookingAppointmentRequest extends BaseRequest<BookingAppointment> {
	
    /**
     * The request for the BookingAppointment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public BookingAppointmentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, BookingAppointment.class);
    }

    /**
     * Gets the BookingAppointment from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingAppointment> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the BookingAppointment from the service
     *
     * @return the BookingAppointment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingAppointment get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingAppointment> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public BookingAppointment delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this BookingAppointment with a source
     *
     * @param sourceBookingAppointment the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingAppointment> patchAsync(@Nonnull final BookingAppointment sourceBookingAppointment) {
        return sendAsync(HttpMethod.PATCH, sourceBookingAppointment);
    }

    /**
     * Patches this BookingAppointment with a source
     *
     * @param sourceBookingAppointment the source object with updates
     * @return the updated BookingAppointment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingAppointment patch(@Nonnull final BookingAppointment sourceBookingAppointment) throws ClientException {
        return send(HttpMethod.PATCH, sourceBookingAppointment);
    }

    /**
     * Creates a BookingAppointment with a new object
     *
     * @param newBookingAppointment the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingAppointment> postAsync(@Nonnull final BookingAppointment newBookingAppointment) {
        return sendAsync(HttpMethod.POST, newBookingAppointment);
    }

    /**
     * Creates a BookingAppointment with a new object
     *
     * @param newBookingAppointment the new object to create
     * @return the created BookingAppointment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingAppointment post(@Nonnull final BookingAppointment newBookingAppointment) throws ClientException {
        return send(HttpMethod.POST, newBookingAppointment);
    }

    /**
     * Creates a BookingAppointment with a new object
     *
     * @param newBookingAppointment the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingAppointment> putAsync(@Nonnull final BookingAppointment newBookingAppointment) {
        return sendAsync(HttpMethod.PUT, newBookingAppointment);
    }

    /**
     * Creates a BookingAppointment with a new object
     *
     * @param newBookingAppointment the object to create/update
     * @return the created BookingAppointment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingAppointment put(@Nonnull final BookingAppointment newBookingAppointment) throws ClientException {
        return send(HttpMethod.PUT, newBookingAppointment);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public BookingAppointmentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public BookingAppointmentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

