// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Calendar;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.ScheduleInformation;
import com.microsoft.graph.models.CalendarRoleType;
import com.microsoft.graph.requests.CalendarPermissionCollectionRequestBuilder;
import com.microsoft.graph.requests.CalendarPermissionRequestBuilder;
import com.microsoft.graph.requests.EventCollectionRequestBuilder;
import com.microsoft.graph.requests.EventRequestBuilder;
import com.microsoft.graph.requests.MultiValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.MultiValueLegacyExtendedPropertyRequestBuilder;
import com.microsoft.graph.requests.SingleValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.SingleValueLegacyExtendedPropertyRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Calendar Request.
 */
public class CalendarRequest extends BaseRequest<Calendar> {
	
    /**
     * The request for the Calendar
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CalendarRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Calendar.class);
    }

    /**
     * Gets the Calendar from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Calendar> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Calendar from the service
     *
     * @return the Calendar from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Calendar get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Calendar> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Calendar delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Calendar with a source
     *
     * @param sourceCalendar the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Calendar> patchAsync(@Nonnull final Calendar sourceCalendar) {
        return sendAsync(HttpMethod.PATCH, sourceCalendar);
    }

    /**
     * Patches this Calendar with a source
     *
     * @param sourceCalendar the source object with updates
     * @return the updated Calendar
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Calendar patch(@Nonnull final Calendar sourceCalendar) throws ClientException {
        return send(HttpMethod.PATCH, sourceCalendar);
    }

    /**
     * Creates a Calendar with a new object
     *
     * @param newCalendar the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Calendar> postAsync(@Nonnull final Calendar newCalendar) {
        return sendAsync(HttpMethod.POST, newCalendar);
    }

    /**
     * Creates a Calendar with a new object
     *
     * @param newCalendar the new object to create
     * @return the created Calendar
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Calendar post(@Nonnull final Calendar newCalendar) throws ClientException {
        return send(HttpMethod.POST, newCalendar);
    }

    /**
     * Creates a Calendar with a new object
     *
     * @param newCalendar the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Calendar> putAsync(@Nonnull final Calendar newCalendar) {
        return sendAsync(HttpMethod.PUT, newCalendar);
    }

    /**
     * Creates a Calendar with a new object
     *
     * @param newCalendar the object to create/update
     * @return the created Calendar
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Calendar put(@Nonnull final Calendar newCalendar) throws ClientException {
        return send(HttpMethod.PUT, newCalendar);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CalendarRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CalendarRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

