// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ManagedAppPolicyDeploymentSummary;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed App Policy Deployment Summary Request.
 */
public class ManagedAppPolicyDeploymentSummaryRequest extends BaseRequest<ManagedAppPolicyDeploymentSummary> {
	
    /**
     * The request for the ManagedAppPolicyDeploymentSummary
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedAppPolicyDeploymentSummaryRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedAppPolicyDeploymentSummary.class);
    }

    /**
     * Gets the ManagedAppPolicyDeploymentSummary from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedAppPolicyDeploymentSummary> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ManagedAppPolicyDeploymentSummary from the service
     *
     * @return the ManagedAppPolicyDeploymentSummary from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedAppPolicyDeploymentSummary get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedAppPolicyDeploymentSummary> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ManagedAppPolicyDeploymentSummary delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ManagedAppPolicyDeploymentSummary with a source
     *
     * @param sourceManagedAppPolicyDeploymentSummary the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedAppPolicyDeploymentSummary> patchAsync(@Nonnull final ManagedAppPolicyDeploymentSummary sourceManagedAppPolicyDeploymentSummary) {
        return sendAsync(HttpMethod.PATCH, sourceManagedAppPolicyDeploymentSummary);
    }

    /**
     * Patches this ManagedAppPolicyDeploymentSummary with a source
     *
     * @param sourceManagedAppPolicyDeploymentSummary the source object with updates
     * @return the updated ManagedAppPolicyDeploymentSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedAppPolicyDeploymentSummary patch(@Nonnull final ManagedAppPolicyDeploymentSummary sourceManagedAppPolicyDeploymentSummary) throws ClientException {
        return send(HttpMethod.PATCH, sourceManagedAppPolicyDeploymentSummary);
    }

    /**
     * Creates a ManagedAppPolicyDeploymentSummary with a new object
     *
     * @param newManagedAppPolicyDeploymentSummary the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedAppPolicyDeploymentSummary> postAsync(@Nonnull final ManagedAppPolicyDeploymentSummary newManagedAppPolicyDeploymentSummary) {
        return sendAsync(HttpMethod.POST, newManagedAppPolicyDeploymentSummary);
    }

    /**
     * Creates a ManagedAppPolicyDeploymentSummary with a new object
     *
     * @param newManagedAppPolicyDeploymentSummary the new object to create
     * @return the created ManagedAppPolicyDeploymentSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedAppPolicyDeploymentSummary post(@Nonnull final ManagedAppPolicyDeploymentSummary newManagedAppPolicyDeploymentSummary) throws ClientException {
        return send(HttpMethod.POST, newManagedAppPolicyDeploymentSummary);
    }

    /**
     * Creates a ManagedAppPolicyDeploymentSummary with a new object
     *
     * @param newManagedAppPolicyDeploymentSummary the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedAppPolicyDeploymentSummary> putAsync(@Nonnull final ManagedAppPolicyDeploymentSummary newManagedAppPolicyDeploymentSummary) {
        return sendAsync(HttpMethod.PUT, newManagedAppPolicyDeploymentSummary);
    }

    /**
     * Creates a ManagedAppPolicyDeploymentSummary with a new object
     *
     * @param newManagedAppPolicyDeploymentSummary the object to create/update
     * @return the created ManagedAppPolicyDeploymentSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedAppPolicyDeploymentSummary put(@Nonnull final ManagedAppPolicyDeploymentSummary newManagedAppPolicyDeploymentSummary) throws ClientException {
        return send(HttpMethod.PUT, newManagedAppPolicyDeploymentSummary);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ManagedAppPolicyDeploymentSummaryRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ManagedAppPolicyDeploymentSummaryRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

