// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Onenote;
import com.microsoft.graph.models.Notebook;
import com.microsoft.graph.models.OnenoteOperation;
import com.microsoft.graph.models.CopyNotebookModel;
import com.microsoft.graph.models.RecentNotebook;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.NotebookCollectionRequestBuilder;
import com.microsoft.graph.requests.NotebookRequestBuilder;
import com.microsoft.graph.requests.NotebookCollectionRequest;
import com.microsoft.graph.requests.NotebookGetNotebookFromWebUrlRequestBuilder;
import com.microsoft.graph.requests.NotebookGetRecentNotebooksCollectionRequestBuilder;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
import com.microsoft.graph.models.NotebookCopyNotebookParameterSet;
import com.microsoft.graph.models.NotebookGetNotebookFromWebUrlParameterSet;
import com.microsoft.graph.models.NotebookGetRecentNotebooksParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Notebook Collection Request Builder.
 */
public class NotebookCollectionRequestBuilder extends BaseCollectionRequestBuilder<Notebook, NotebookRequestBuilder, NotebookCollectionResponse, NotebookCollectionPage, NotebookCollectionRequest> {

    /**
     * The request builder for this collection of Onenote
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public NotebookCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, NotebookRequestBuilder.class, NotebookCollectionRequest.class);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public NotebookGetNotebookFromWebUrlRequestBuilder getNotebookFromWebUrl(@Nonnull final NotebookGetNotebookFromWebUrlParameterSet parameters) {
        return new NotebookGetNotebookFromWebUrlRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getNotebookFromWebUrl"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder collection
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public NotebookGetRecentNotebooksCollectionRequestBuilder getRecentNotebooks(@Nonnull final NotebookGetRecentNotebooksParameterSet parameters) {
        return new NotebookGetRecentNotebooksCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getRecentNotebooks"), getClient(), null, parameters);
    }

    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
