// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.WorkbookChartLineFormatClearRequest;
import com.microsoft.graph.models.WorkbookChartLineFormat;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Line Format Clear Request Builder.
 */
public class WorkbookChartLineFormatClearRequestBuilder extends BaseActionRequestBuilder<WorkbookChartLineFormat> {

    /**
     * The request builder for this WorkbookChartLineFormatClear
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartLineFormatClearRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the WorkbookChartLineFormatClearRequest
     *
     * @param requestOptions the options for the request
     * @return the WorkbookChartLineFormatClearRequest instance
     */
    @Nonnull
    public WorkbookChartLineFormatClearRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the WorkbookChartLineFormatClearRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the WorkbookChartLineFormatClearRequest instance
     */
    @Nonnull
    public WorkbookChartLineFormatClearRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final WorkbookChartLineFormatClearRequest request = new WorkbookChartLineFormatClearRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
