// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.callrecords.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.callrecords.models.UserFeedback;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.callrecords.models.Endpoint;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Participant Endpoint.
 */
public class ParticipantEndpoint extends Endpoint implements IJsonBackedObject {


    /**
     * The Feedback.
     * The feedback provided by the user of this endpoint about the quality of the session.
     */
    @SerializedName(value = "feedback", alternate = {"Feedback"})
    @Expose
	@Nullable
    public UserFeedback feedback;

    /**
     * The Identity.
     * Identity associated with the endpoint.
     */
    @SerializedName(value = "identity", alternate = {"Identity"})
    @Expose
	@Nullable
    public IdentitySet identity;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
