// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.CountryNamedLocation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Country Named Location Request.
 */
public class CountryNamedLocationRequest extends BaseRequest<CountryNamedLocation> {
	
    /**
     * The request for the CountryNamedLocation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CountryNamedLocationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CountryNamedLocation.class);
    }

    /**
     * Gets the CountryNamedLocation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CountryNamedLocation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CountryNamedLocation from the service
     *
     * @return the CountryNamedLocation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CountryNamedLocation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CountryNamedLocation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CountryNamedLocation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CountryNamedLocation with a source
     *
     * @param sourceCountryNamedLocation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CountryNamedLocation> patchAsync(@Nonnull final CountryNamedLocation sourceCountryNamedLocation) {
        return sendAsync(HttpMethod.PATCH, sourceCountryNamedLocation);
    }

    /**
     * Patches this CountryNamedLocation with a source
     *
     * @param sourceCountryNamedLocation the source object with updates
     * @return the updated CountryNamedLocation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CountryNamedLocation patch(@Nonnull final CountryNamedLocation sourceCountryNamedLocation) throws ClientException {
        return send(HttpMethod.PATCH, sourceCountryNamedLocation);
    }

    /**
     * Creates a CountryNamedLocation with a new object
     *
     * @param newCountryNamedLocation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CountryNamedLocation> postAsync(@Nonnull final CountryNamedLocation newCountryNamedLocation) {
        return sendAsync(HttpMethod.POST, newCountryNamedLocation);
    }

    /**
     * Creates a CountryNamedLocation with a new object
     *
     * @param newCountryNamedLocation the new object to create
     * @return the created CountryNamedLocation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CountryNamedLocation post(@Nonnull final CountryNamedLocation newCountryNamedLocation) throws ClientException {
        return send(HttpMethod.POST, newCountryNamedLocation);
    }

    /**
     * Creates a CountryNamedLocation with a new object
     *
     * @param newCountryNamedLocation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CountryNamedLocation> putAsync(@Nonnull final CountryNamedLocation newCountryNamedLocation) {
        return sendAsync(HttpMethod.PUT, newCountryNamedLocation);
    }

    /**
     * Creates a CountryNamedLocation with a new object
     *
     * @param newCountryNamedLocation the object to create/update
     * @return the created CountryNamedLocation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CountryNamedLocation put(@Nonnull final CountryNamedLocation newCountryNamedLocation) throws ClientException {
        return send(HttpMethod.PUT, newCountryNamedLocation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CountryNamedLocationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CountryNamedLocationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

