// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceConfigurationDeviceStatus;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Configuration Device Status Request.
 */
public class DeviceConfigurationDeviceStatusRequest extends BaseRequest<DeviceConfigurationDeviceStatus> {
	
    /**
     * The request for the DeviceConfigurationDeviceStatus
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceConfigurationDeviceStatusRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceConfigurationDeviceStatus.class);
    }

    /**
     * Gets the DeviceConfigurationDeviceStatus from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationDeviceStatus> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeviceConfigurationDeviceStatus from the service
     *
     * @return the DeviceConfigurationDeviceStatus from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationDeviceStatus get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationDeviceStatus> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeviceConfigurationDeviceStatus delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceConfigurationDeviceStatus with a source
     *
     * @param sourceDeviceConfigurationDeviceStatus the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationDeviceStatus> patchAsync(@Nonnull final DeviceConfigurationDeviceStatus sourceDeviceConfigurationDeviceStatus) {
        return sendAsync(HttpMethod.PATCH, sourceDeviceConfigurationDeviceStatus);
    }

    /**
     * Patches this DeviceConfigurationDeviceStatus with a source
     *
     * @param sourceDeviceConfigurationDeviceStatus the source object with updates
     * @return the updated DeviceConfigurationDeviceStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationDeviceStatus patch(@Nonnull final DeviceConfigurationDeviceStatus sourceDeviceConfigurationDeviceStatus) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceConfigurationDeviceStatus);
    }

    /**
     * Creates a DeviceConfigurationDeviceStatus with a new object
     *
     * @param newDeviceConfigurationDeviceStatus the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationDeviceStatus> postAsync(@Nonnull final DeviceConfigurationDeviceStatus newDeviceConfigurationDeviceStatus) {
        return sendAsync(HttpMethod.POST, newDeviceConfigurationDeviceStatus);
    }

    /**
     * Creates a DeviceConfigurationDeviceStatus with a new object
     *
     * @param newDeviceConfigurationDeviceStatus the new object to create
     * @return the created DeviceConfigurationDeviceStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationDeviceStatus post(@Nonnull final DeviceConfigurationDeviceStatus newDeviceConfigurationDeviceStatus) throws ClientException {
        return send(HttpMethod.POST, newDeviceConfigurationDeviceStatus);
    }

    /**
     * Creates a DeviceConfigurationDeviceStatus with a new object
     *
     * @param newDeviceConfigurationDeviceStatus the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationDeviceStatus> putAsync(@Nonnull final DeviceConfigurationDeviceStatus newDeviceConfigurationDeviceStatus) {
        return sendAsync(HttpMethod.PUT, newDeviceConfigurationDeviceStatus);
    }

    /**
     * Creates a DeviceConfigurationDeviceStatus with a new object
     *
     * @param newDeviceConfigurationDeviceStatus the object to create/update
     * @return the created DeviceConfigurationDeviceStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationDeviceStatus put(@Nonnull final DeviceConfigurationDeviceStatus newDeviceConfigurationDeviceStatus) throws ClientException {
        return send(HttpMethod.PUT, newDeviceConfigurationDeviceStatus);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeviceConfigurationDeviceStatusRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeviceConfigurationDeviceStatusRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

