// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceConfigurationUserOverview;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Configuration User Overview Request.
 */
public class DeviceConfigurationUserOverviewRequest extends BaseRequest<DeviceConfigurationUserOverview> {
	
    /**
     * The request for the DeviceConfigurationUserOverview
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceConfigurationUserOverviewRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceConfigurationUserOverview.class);
    }

    /**
     * Gets the DeviceConfigurationUserOverview from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationUserOverview> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeviceConfigurationUserOverview from the service
     *
     * @return the DeviceConfigurationUserOverview from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationUserOverview get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationUserOverview> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeviceConfigurationUserOverview delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceConfigurationUserOverview with a source
     *
     * @param sourceDeviceConfigurationUserOverview the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationUserOverview> patchAsync(@Nonnull final DeviceConfigurationUserOverview sourceDeviceConfigurationUserOverview) {
        return sendAsync(HttpMethod.PATCH, sourceDeviceConfigurationUserOverview);
    }

    /**
     * Patches this DeviceConfigurationUserOverview with a source
     *
     * @param sourceDeviceConfigurationUserOverview the source object with updates
     * @return the updated DeviceConfigurationUserOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationUserOverview patch(@Nonnull final DeviceConfigurationUserOverview sourceDeviceConfigurationUserOverview) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceConfigurationUserOverview);
    }

    /**
     * Creates a DeviceConfigurationUserOverview with a new object
     *
     * @param newDeviceConfigurationUserOverview the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationUserOverview> postAsync(@Nonnull final DeviceConfigurationUserOverview newDeviceConfigurationUserOverview) {
        return sendAsync(HttpMethod.POST, newDeviceConfigurationUserOverview);
    }

    /**
     * Creates a DeviceConfigurationUserOverview with a new object
     *
     * @param newDeviceConfigurationUserOverview the new object to create
     * @return the created DeviceConfigurationUserOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationUserOverview post(@Nonnull final DeviceConfigurationUserOverview newDeviceConfigurationUserOverview) throws ClientException {
        return send(HttpMethod.POST, newDeviceConfigurationUserOverview);
    }

    /**
     * Creates a DeviceConfigurationUserOverview with a new object
     *
     * @param newDeviceConfigurationUserOverview the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationUserOverview> putAsync(@Nonnull final DeviceConfigurationUserOverview newDeviceConfigurationUserOverview) {
        return sendAsync(HttpMethod.PUT, newDeviceConfigurationUserOverview);
    }

    /**
     * Creates a DeviceConfigurationUserOverview with a new object
     *
     * @param newDeviceConfigurationUserOverview the object to create/update
     * @return the created DeviceConfigurationUserOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationUserOverview put(@Nonnull final DeviceConfigurationUserOverview newDeviceConfigurationUserOverview) throws ClientException {
        return send(HttpMethod.PUT, newDeviceConfigurationUserOverview);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeviceConfigurationUserOverviewRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeviceConfigurationUserOverviewRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

