// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceManagementPartner;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Management Partner Request.
 */
public class DeviceManagementPartnerRequest extends BaseRequest<DeviceManagementPartner> {
	
    /**
     * The request for the DeviceManagementPartner
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceManagementPartnerRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceManagementPartner.class);
    }

    /**
     * Gets the DeviceManagementPartner from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementPartner> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeviceManagementPartner from the service
     *
     * @return the DeviceManagementPartner from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementPartner get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementPartner> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeviceManagementPartner delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceManagementPartner with a source
     *
     * @param sourceDeviceManagementPartner the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementPartner> patchAsync(@Nonnull final DeviceManagementPartner sourceDeviceManagementPartner) {
        return sendAsync(HttpMethod.PATCH, sourceDeviceManagementPartner);
    }

    /**
     * Patches this DeviceManagementPartner with a source
     *
     * @param sourceDeviceManagementPartner the source object with updates
     * @return the updated DeviceManagementPartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementPartner patch(@Nonnull final DeviceManagementPartner sourceDeviceManagementPartner) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceManagementPartner);
    }

    /**
     * Creates a DeviceManagementPartner with a new object
     *
     * @param newDeviceManagementPartner the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementPartner> postAsync(@Nonnull final DeviceManagementPartner newDeviceManagementPartner) {
        return sendAsync(HttpMethod.POST, newDeviceManagementPartner);
    }

    /**
     * Creates a DeviceManagementPartner with a new object
     *
     * @param newDeviceManagementPartner the new object to create
     * @return the created DeviceManagementPartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementPartner post(@Nonnull final DeviceManagementPartner newDeviceManagementPartner) throws ClientException {
        return send(HttpMethod.POST, newDeviceManagementPartner);
    }

    /**
     * Creates a DeviceManagementPartner with a new object
     *
     * @param newDeviceManagementPartner the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementPartner> putAsync(@Nonnull final DeviceManagementPartner newDeviceManagementPartner) {
        return sendAsync(HttpMethod.PUT, newDeviceManagementPartner);
    }

    /**
     * Creates a DeviceManagementPartner with a new object
     *
     * @param newDeviceManagementPartner the object to create/update
     * @return the created DeviceManagementPartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementPartner put(@Nonnull final DeviceManagementPartner newDeviceManagementPartner) throws ClientException {
        return send(HttpMethod.PUT, newDeviceManagementPartner);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeviceManagementPartnerRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeviceManagementPartnerRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

