// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IosUpdateConfiguration;
import com.microsoft.graph.models.DeviceConfigurationAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ios Update Configuration Request.
 */
public class IosUpdateConfigurationRequest extends BaseRequest<IosUpdateConfiguration> {
	
    /**
     * The request for the IosUpdateConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IosUpdateConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IosUpdateConfiguration.class);
    }

    /**
     * Gets the IosUpdateConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosUpdateConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IosUpdateConfiguration from the service
     *
     * @return the IosUpdateConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosUpdateConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosUpdateConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IosUpdateConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IosUpdateConfiguration with a source
     *
     * @param sourceIosUpdateConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosUpdateConfiguration> patchAsync(@Nonnull final IosUpdateConfiguration sourceIosUpdateConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceIosUpdateConfiguration);
    }

    /**
     * Patches this IosUpdateConfiguration with a source
     *
     * @param sourceIosUpdateConfiguration the source object with updates
     * @return the updated IosUpdateConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosUpdateConfiguration patch(@Nonnull final IosUpdateConfiguration sourceIosUpdateConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceIosUpdateConfiguration);
    }

    /**
     * Creates a IosUpdateConfiguration with a new object
     *
     * @param newIosUpdateConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosUpdateConfiguration> postAsync(@Nonnull final IosUpdateConfiguration newIosUpdateConfiguration) {
        return sendAsync(HttpMethod.POST, newIosUpdateConfiguration);
    }

    /**
     * Creates a IosUpdateConfiguration with a new object
     *
     * @param newIosUpdateConfiguration the new object to create
     * @return the created IosUpdateConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosUpdateConfiguration post(@Nonnull final IosUpdateConfiguration newIosUpdateConfiguration) throws ClientException {
        return send(HttpMethod.POST, newIosUpdateConfiguration);
    }

    /**
     * Creates a IosUpdateConfiguration with a new object
     *
     * @param newIosUpdateConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosUpdateConfiguration> putAsync(@Nonnull final IosUpdateConfiguration newIosUpdateConfiguration) {
        return sendAsync(HttpMethod.PUT, newIosUpdateConfiguration);
    }

    /**
     * Creates a IosUpdateConfiguration with a new object
     *
     * @param newIosUpdateConfiguration the object to create/update
     * @return the created IosUpdateConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosUpdateConfiguration put(@Nonnull final IosUpdateConfiguration newIosUpdateConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newIosUpdateConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IosUpdateConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IosUpdateConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

