// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.externalconnectors.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.externalconnectors.models.ExternalItem;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the External Item Request.
 */
public class ExternalItemRequest extends BaseRequest<ExternalItem> {
	
    /**
     * The request for the ExternalItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ExternalItemRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ExternalItem.class);
    }

    /**
     * Gets the ExternalItem from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalItem> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ExternalItem from the service
     *
     * @return the ExternalItem from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExternalItem get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalItem> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ExternalItem delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ExternalItem with a source
     *
     * @param sourceExternalItem the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalItem> patchAsync(@Nonnull final ExternalItem sourceExternalItem) {
        return sendAsync(HttpMethod.PATCH, sourceExternalItem);
    }

    /**
     * Patches this ExternalItem with a source
     *
     * @param sourceExternalItem the source object with updates
     * @return the updated ExternalItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExternalItem patch(@Nonnull final ExternalItem sourceExternalItem) throws ClientException {
        return send(HttpMethod.PATCH, sourceExternalItem);
    }

    /**
     * Creates a ExternalItem with a new object
     *
     * @param newExternalItem the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalItem> postAsync(@Nonnull final ExternalItem newExternalItem) {
        return sendAsync(HttpMethod.POST, newExternalItem);
    }

    /**
     * Creates a ExternalItem with a new object
     *
     * @param newExternalItem the new object to create
     * @return the created ExternalItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExternalItem post(@Nonnull final ExternalItem newExternalItem) throws ClientException {
        return send(HttpMethod.POST, newExternalItem);
    }

    /**
     * Creates a ExternalItem with a new object
     *
     * @param newExternalItem the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ExternalItem> putAsync(@Nonnull final ExternalItem newExternalItem) {
        return sendAsync(HttpMethod.PUT, newExternalItem);
    }

    /**
     * Creates a ExternalItem with a new object
     *
     * @param newExternalItem the object to create/update
     * @return the created ExternalItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ExternalItem put(@Nonnull final ExternalItem newExternalItem) throws ClientException {
        return send(HttpMethod.PUT, newExternalItem);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ExternalItemRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ExternalItemRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

