// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationRoot;
import com.microsoft.graph.requests.EducationClassCollectionRequestBuilder;
import com.microsoft.graph.requests.EducationClassRequestBuilder;
import com.microsoft.graph.requests.EducationUserRequestBuilder;
import com.microsoft.graph.requests.EducationSchoolCollectionRequestBuilder;
import com.microsoft.graph.requests.EducationSchoolRequestBuilder;
import com.microsoft.graph.requests.EducationUserCollectionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Root Request.
 */
public class EducationRootRequest extends BaseRequest<EducationRoot> {
	
    /**
     * The request for the EducationRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationRootRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationRoot.class);
    }

    /**
     * Gets the EducationRoot from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRoot> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EducationRoot from the service
     *
     * @return the EducationRoot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationRoot get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRoot> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EducationRoot delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EducationRoot with a source
     *
     * @param sourceEducationRoot the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRoot> patchAsync(@Nonnull final EducationRoot sourceEducationRoot) {
        return sendAsync(HttpMethod.PATCH, sourceEducationRoot);
    }

    /**
     * Patches this EducationRoot with a source
     *
     * @param sourceEducationRoot the source object with updates
     * @return the updated EducationRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationRoot patch(@Nonnull final EducationRoot sourceEducationRoot) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationRoot);
    }

    /**
     * Creates a EducationRoot with a new object
     *
     * @param newEducationRoot the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRoot> postAsync(@Nonnull final EducationRoot newEducationRoot) {
        return sendAsync(HttpMethod.POST, newEducationRoot);
    }

    /**
     * Creates a EducationRoot with a new object
     *
     * @param newEducationRoot the new object to create
     * @return the created EducationRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationRoot post(@Nonnull final EducationRoot newEducationRoot) throws ClientException {
        return send(HttpMethod.POST, newEducationRoot);
    }

    /**
     * Creates a EducationRoot with a new object
     *
     * @param newEducationRoot the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRoot> putAsync(@Nonnull final EducationRoot newEducationRoot) {
        return sendAsync(HttpMethod.PUT, newEducationRoot);
    }

    /**
     * Creates a EducationRoot with a new object
     *
     * @param newEducationRoot the object to create/update
     * @return the created EducationRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationRoot put(@Nonnull final EducationRoot newEducationRoot) throws ClientException {
        return send(HttpMethod.PUT, newEducationRoot);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EducationRootRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EducationRootRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

