// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Team;
import com.microsoft.graph.models.TeamVisibilityType;
import com.microsoft.graph.models.ClonableTeamParts;
import java.util.EnumSet;
import com.microsoft.graph.models.TeamworkActivityTopic;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.KeyValuePair;
import com.microsoft.graph.models.TeamworkNotificationRecipient;
import com.microsoft.graph.models.ChatMessage;
import com.microsoft.graph.requests.ChannelCollectionRequestBuilder;
import com.microsoft.graph.requests.ChannelRequestBuilder;
import com.microsoft.graph.requests.GroupWithReferenceRequestBuilder;
import com.microsoft.graph.requests.TeamsAppInstallationCollectionRequestBuilder;
import com.microsoft.graph.requests.TeamsAppInstallationRequestBuilder;
import com.microsoft.graph.requests.ConversationMemberCollectionRequestBuilder;
import com.microsoft.graph.requests.ConversationMemberRequestBuilder;
import com.microsoft.graph.requests.TeamsAsyncOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.TeamsAsyncOperationRequestBuilder;
import com.microsoft.graph.requests.TeamsTemplateWithReferenceRequestBuilder;
import com.microsoft.graph.requests.ScheduleRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Team Request.
 */
public class TeamRequest extends BaseRequest<Team> {
	
    /**
     * The request for the Team
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Team.class);
    }

    /**
     * Gets the Team from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Team> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Team from the service
     *
     * @return the Team from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Team get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Team> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Team delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Team with a source
     *
     * @param sourceTeam the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Team> patchAsync(@Nonnull final Team sourceTeam) {
        return sendAsync(HttpMethod.PATCH, sourceTeam);
    }

    /**
     * Patches this Team with a source
     *
     * @param sourceTeam the source object with updates
     * @return the updated Team
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Team patch(@Nonnull final Team sourceTeam) throws ClientException {
        return send(HttpMethod.PATCH, sourceTeam);
    }

    /**
     * Creates a Team with a new object
     *
     * @param newTeam the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Team> postAsync(@Nonnull final Team newTeam) {
        return sendAsync(HttpMethod.POST, newTeam);
    }

    /**
     * Creates a Team with a new object
     *
     * @param newTeam the new object to create
     * @return the created Team
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Team post(@Nonnull final Team newTeam) throws ClientException {
        return send(HttpMethod.POST, newTeam);
    }

    /**
     * Creates a Team with a new object
     *
     * @param newTeam the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Team> putAsync(@Nonnull final Team newTeam) {
        return sendAsync(HttpMethod.PUT, newTeam);
    }

    /**
     * Creates a Team with a new object
     *
     * @param newTeam the object to create/update
     * @return the created Team
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Team put(@Nonnull final Team newTeam) throws ClientException {
        return send(HttpMethod.PUT, newTeam);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TeamRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TeamRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

