// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ContentType;
import com.microsoft.graph.models.ItemReference;
import com.microsoft.graph.requests.ContentTypeWithReferenceRequestBuilder;
import com.microsoft.graph.requests.ContentTypeCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ColumnLinkCollectionRequestBuilder;
import com.microsoft.graph.requests.ColumnLinkRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionWithReferenceRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Content Type Request.
 */
public class ContentTypeRequest extends BaseRequest<ContentType> {
	
    /**
     * The request for the ContentType
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ContentTypeRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContentType.class);
    }

    /**
     * Gets the ContentType from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContentType> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ContentType from the service
     *
     * @return the ContentType from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ContentType get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContentType> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ContentType delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ContentType with a source
     *
     * @param sourceContentType the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContentType> patchAsync(@Nonnull final ContentType sourceContentType) {
        return sendAsync(HttpMethod.PATCH, sourceContentType);
    }

    /**
     * Patches this ContentType with a source
     *
     * @param sourceContentType the source object with updates
     * @return the updated ContentType
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ContentType patch(@Nonnull final ContentType sourceContentType) throws ClientException {
        return send(HttpMethod.PATCH, sourceContentType);
    }

    /**
     * Creates a ContentType with a new object
     *
     * @param newContentType the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContentType> postAsync(@Nonnull final ContentType newContentType) {
        return sendAsync(HttpMethod.POST, newContentType);
    }

    /**
     * Creates a ContentType with a new object
     *
     * @param newContentType the new object to create
     * @return the created ContentType
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ContentType post(@Nonnull final ContentType newContentType) throws ClientException {
        return send(HttpMethod.POST, newContentType);
    }

    /**
     * Creates a ContentType with a new object
     *
     * @param newContentType the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ContentType> putAsync(@Nonnull final ContentType newContentType) {
        return sendAsync(HttpMethod.PUT, newContentType);
    }

    /**
     * Creates a ContentType with a new object
     *
     * @param newContentType the object to create/update
     * @return the created ContentType
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ContentType put(@Nonnull final ContentType newContentType) throws ClientException {
        return send(HttpMethod.PUT, newContentType);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ContentTypeRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ContentTypeRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

