// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Permission Scope.
 */
public class PermissionScope implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Admin Consent Description.
     * A description of the delegated permissions, intended to be read by an administrator granting the permission on behalf of all users. This text appears in tenant-wide admin consent experiences.
     */
    @SerializedName(value = "adminConsentDescription", alternate = {"AdminConsentDescription"})
    @Expose
	@Nullable
    public String adminConsentDescription;

    /**
     * The Admin Consent Display Name.
     * The permission's title, intended to be read by an administrator granting the permission on behalf of all users.
     */
    @SerializedName(value = "adminConsentDisplayName", alternate = {"AdminConsentDisplayName"})
    @Expose
	@Nullable
    public String adminConsentDisplayName;

    /**
     * The Id.
     * Unique delegated permission identifier inside the collection of delegated permissions defined for a resource application.
     */
    @SerializedName(value = "id", alternate = {"Id"})
    @Expose
	@Nullable
    public java.util.UUID id;

    /**
     * The Is Enabled.
     * When creating or updating a permission, this property must be set to true (which is the default). To delete a permission, this property must first be set to false.  At that point, in a subsequent call, the permission may be removed.
     */
    @SerializedName(value = "isEnabled", alternate = {"IsEnabled"})
    @Expose
	@Nullable
    public Boolean isEnabled;

    /**
     * The Origin.
     * 
     */
    @SerializedName(value = "origin", alternate = {"Origin"})
    @Expose
	@Nullable
    public String origin;

    /**
     * The Type.
     * The possible values are: User and Admin. Specifies whether this delegated permission should be considered safe for non-admin users to consent to on behalf of themselves, or whether an administrator consent should always be required. While Microsoft Graph defines the default consent requirement for each permission, the tenant administrator may override the behavior in their organization (by allowing, restricting, or limiting user consent to this delegated permission). For more information, see Configure how users consent to applications.
     */
    @SerializedName(value = "type", alternate = {"Type"})
    @Expose
	@Nullable
    public String type;

    /**
     * The User Consent Description.
     * A description of the delegated permissions, intended to be read by a user granting the permission on their own behalf. This text appears in consent experiences where the user is consenting only on behalf of themselves.
     */
    @SerializedName(value = "userConsentDescription", alternate = {"UserConsentDescription"})
    @Expose
	@Nullable
    public String userConsentDescription;

    /**
     * The User Consent Display Name.
     * A title for the permission, intended to be read by a user granting the permission on their own behalf. This text appears in consent experiences where the user is consenting only on behalf of themselves.
     */
    @SerializedName(value = "userConsentDisplayName", alternate = {"UserConsentDisplayName"})
    @Expose
	@Nullable
    public String userConsentDisplayName;

    /**
     * The Value.
     * Specifies the value to include in the scp (scope) claim in access tokens. Must not exceed 120 characters in length. Allowed characters are : ! # $ % &amp; ' ( ) * + , - . / : ;  =  ? @ [ ] ^ + _  {  } ~, as well as characters in the ranges 0-9, A-Z and a-z. Any other character, including the space character, are not allowed. May not begin with ..
     */
    @SerializedName(value = "value", alternate = {"Value"})
    @Expose
	@Nullable
    public String value;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
