// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AuthenticationMethodTarget;
import com.microsoft.graph.models.AuthenticationMethodConfiguration;
import com.microsoft.graph.requests.AuthenticationMethodTargetCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Temporary Access Pass Authentication Method Configuration.
 */
public class TemporaryAccessPassAuthenticationMethodConfiguration extends AuthenticationMethodConfiguration implements IJsonBackedObject {


    /**
     * The Default Length.
     * 
     */
    @SerializedName(value = "defaultLength", alternate = {"DefaultLength"})
    @Expose
	@Nullable
    public Integer defaultLength;

    /**
     * The Default Lifetime In Minutes.
     * 
     */
    @SerializedName(value = "defaultLifetimeInMinutes", alternate = {"DefaultLifetimeInMinutes"})
    @Expose
	@Nullable
    public Integer defaultLifetimeInMinutes;

    /**
     * The Is Usable Once.
     * 
     */
    @SerializedName(value = "isUsableOnce", alternate = {"IsUsableOnce"})
    @Expose
	@Nullable
    public Boolean isUsableOnce;

    /**
     * The Maximum Lifetime In Minutes.
     * 
     */
    @SerializedName(value = "maximumLifetimeInMinutes", alternate = {"MaximumLifetimeInMinutes"})
    @Expose
	@Nullable
    public Integer maximumLifetimeInMinutes;

    /**
     * The Minimum Lifetime In Minutes.
     * 
     */
    @SerializedName(value = "minimumLifetimeInMinutes", alternate = {"MinimumLifetimeInMinutes"})
    @Expose
	@Nullable
    public Integer minimumLifetimeInMinutes;

    /**
     * The Include Targets.
     * 
     */
    @SerializedName(value = "includeTargets", alternate = {"IncludeTargets"})
    @Expose
	@Nullable
    public AuthenticationMethodTargetCollectionPage includeTargets;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("includeTargets")) {
            includeTargets = serializer.deserializeObject(json.get("includeTargets"), AuthenticationMethodTargetCollectionPage.class);
        }
    }
}
