// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Filter Apply Bottom Items Filter Parameter Set.
 */
public class WorkbookFilterApplyBottomItemsFilterParameterSet {
    /**
     * The count.
     * 
     */
    @SerializedName(value = "count", alternate = {"Count"})
    @Expose
	@Nullable
    public Integer count;


    /**
     * Instiaciates a new WorkbookFilterApplyBottomItemsFilterParameterSet
     */
    public WorkbookFilterApplyBottomItemsFilterParameterSet() {}
    /**
     * Instiaciates a new WorkbookFilterApplyBottomItemsFilterParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFilterApplyBottomItemsFilterParameterSet(@Nonnull final WorkbookFilterApplyBottomItemsFilterParameterSetBuilder builder) {
        this.count = builder.count;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFilterApplyBottomItemsFilterParameterSetBuilder newBuilder() {
        return new WorkbookFilterApplyBottomItemsFilterParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFilterApplyBottomItemsFilterParameterSet
     */
    public static final class WorkbookFilterApplyBottomItemsFilterParameterSetBuilder {
        /**
         * The count parameter value
         */
        @Nullable
        protected Integer count;
        /**
         * Sets the Count
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFilterApplyBottomItemsFilterParameterSetBuilder withCount(@Nullable final Integer val) {
            this.count = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFilterApplyBottomItemsFilterParameterSetBuilder
         */
        @Nullable
        protected WorkbookFilterApplyBottomItemsFilterParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFilterApplyBottomItemsFilterParameterSet build() {
            return new WorkbookFilterApplyBottomItemsFilterParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.count != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("count", count));
        }
        return result;
    }
}
