// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TemporaryAccessPassAuthenticationMethodConfiguration;
import com.microsoft.graph.requests.AuthenticationMethodTargetCollectionRequestBuilder;
import com.microsoft.graph.requests.AuthenticationMethodTargetRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Temporary Access Pass Authentication Method Configuration Request.
 */
public class TemporaryAccessPassAuthenticationMethodConfigurationRequest extends BaseRequest<TemporaryAccessPassAuthenticationMethodConfiguration> {
	
    /**
     * The request for the TemporaryAccessPassAuthenticationMethodConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TemporaryAccessPassAuthenticationMethodConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TemporaryAccessPassAuthenticationMethodConfiguration.class);
    }

    /**
     * Gets the TemporaryAccessPassAuthenticationMethodConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TemporaryAccessPassAuthenticationMethodConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TemporaryAccessPassAuthenticationMethodConfiguration from the service
     *
     * @return the TemporaryAccessPassAuthenticationMethodConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TemporaryAccessPassAuthenticationMethodConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TemporaryAccessPassAuthenticationMethodConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TemporaryAccessPassAuthenticationMethodConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TemporaryAccessPassAuthenticationMethodConfiguration with a source
     *
     * @param sourceTemporaryAccessPassAuthenticationMethodConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TemporaryAccessPassAuthenticationMethodConfiguration> patchAsync(@Nonnull final TemporaryAccessPassAuthenticationMethodConfiguration sourceTemporaryAccessPassAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceTemporaryAccessPassAuthenticationMethodConfiguration);
    }

    /**
     * Patches this TemporaryAccessPassAuthenticationMethodConfiguration with a source
     *
     * @param sourceTemporaryAccessPassAuthenticationMethodConfiguration the source object with updates
     * @return the updated TemporaryAccessPassAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TemporaryAccessPassAuthenticationMethodConfiguration patch(@Nonnull final TemporaryAccessPassAuthenticationMethodConfiguration sourceTemporaryAccessPassAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceTemporaryAccessPassAuthenticationMethodConfiguration);
    }

    /**
     * Creates a TemporaryAccessPassAuthenticationMethodConfiguration with a new object
     *
     * @param newTemporaryAccessPassAuthenticationMethodConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TemporaryAccessPassAuthenticationMethodConfiguration> postAsync(@Nonnull final TemporaryAccessPassAuthenticationMethodConfiguration newTemporaryAccessPassAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.POST, newTemporaryAccessPassAuthenticationMethodConfiguration);
    }

    /**
     * Creates a TemporaryAccessPassAuthenticationMethodConfiguration with a new object
     *
     * @param newTemporaryAccessPassAuthenticationMethodConfiguration the new object to create
     * @return the created TemporaryAccessPassAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TemporaryAccessPassAuthenticationMethodConfiguration post(@Nonnull final TemporaryAccessPassAuthenticationMethodConfiguration newTemporaryAccessPassAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.POST, newTemporaryAccessPassAuthenticationMethodConfiguration);
    }

    /**
     * Creates a TemporaryAccessPassAuthenticationMethodConfiguration with a new object
     *
     * @param newTemporaryAccessPassAuthenticationMethodConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TemporaryAccessPassAuthenticationMethodConfiguration> putAsync(@Nonnull final TemporaryAccessPassAuthenticationMethodConfiguration newTemporaryAccessPassAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PUT, newTemporaryAccessPassAuthenticationMethodConfiguration);
    }

    /**
     * Creates a TemporaryAccessPassAuthenticationMethodConfiguration with a new object
     *
     * @param newTemporaryAccessPassAuthenticationMethodConfiguration the object to create/update
     * @return the created TemporaryAccessPassAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TemporaryAccessPassAuthenticationMethodConfiguration put(@Nonnull final TemporaryAccessPassAuthenticationMethodConfiguration newTemporaryAccessPassAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newTemporaryAccessPassAuthenticationMethodConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TemporaryAccessPassAuthenticationMethodConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TemporaryAccessPassAuthenticationMethodConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

