// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.SharedInsight;
import com.microsoft.graph.models.Trending;
import com.microsoft.graph.models.UsedInsight;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.SharedInsightCollectionPage;
import com.microsoft.graph.requests.TrendingCollectionPage;
import com.microsoft.graph.requests.UsedInsightCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Office Graph Insights.
 */
public class OfficeGraphInsights extends Entity implements IJsonBackedObject {


    /**
     * The Shared.
     * Access this property from the derived type itemInsights.
     */
    @SerializedName(value = "shared", alternate = {"Shared"})
    @Expose
	@Nullable
    public SharedInsightCollectionPage shared;

    /**
     * The Trending.
     * Access this property from the derived type itemInsights.
     */
    @SerializedName(value = "trending", alternate = {"Trending"})
    @Expose
	@Nullable
    public TrendingCollectionPage trending;

    /**
     * The Used.
     * Access this property from the derived type itemInsights.
     */
    @SerializedName(value = "used", alternate = {"Used"})
    @Expose
	@Nullable
    public UsedInsightCollectionPage used;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("shared")) {
            shared = serializer.deserializeObject(json.get("shared"), SharedInsightCollectionPage.class);
        }

        if (json.has("trending")) {
            trending = serializer.deserializeObject(json.get("trending"), TrendingCollectionPage.class);
        }

        if (json.has("used")) {
            used = serializer.deserializeObject(json.get("used"), UsedInsightCollectionPage.class);
        }
    }
}
