// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.Post;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Post Reply Parameter Set.
 */
public class PostReplyParameterSet {
    /**
     * The post.
     * 
     */
    @SerializedName(value = "post", alternate = {"Post"})
    @Expose
	@Nullable
    public Post post;


    /**
     * Instiaciates a new PostReplyParameterSet
     */
    public PostReplyParameterSet() {}
    /**
     * Instiaciates a new PostReplyParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected PostReplyParameterSet(@Nonnull final PostReplyParameterSetBuilder builder) {
        this.post = builder.post;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static PostReplyParameterSetBuilder newBuilder() {
        return new PostReplyParameterSetBuilder();
    }
    /**
     * Fluent builder for the PostReplyParameterSet
     */
    public static final class PostReplyParameterSetBuilder {
        /**
         * The post parameter value
         */
        @Nullable
        protected Post post;
        /**
         * Sets the Post
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PostReplyParameterSetBuilder withPost(@Nullable final Post val) {
            this.post = val;
            return this;
        }
        /**
         * Instanciates a new PostReplyParameterSetBuilder
         */
        @Nullable
        protected PostReplyParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public PostReplyParameterSet build() {
            return new PostReplyParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.post != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("post", post));
        }
        return result;
    }
}
