// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookSortField;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Table Sort Apply Parameter Set.
 */
public class WorkbookTableSortApplyParameterSet {
    /**
     * The fields.
     * 
     */
    @SerializedName(value = "fields", alternate = {"Fields"})
    @Expose
	@Nullable
    public java.util.List<WorkbookSortField> fields;

    /**
     * The match Case.
     * 
     */
    @SerializedName(value = "matchCase", alternate = {"MatchCase"})
    @Expose
	@Nullable
    public Boolean matchCase;

    /**
     * The method.
     * 
     */
    @SerializedName(value = "method", alternate = {"Method"})
    @Expose
	@Nullable
    public String method;


    /**
     * Instiaciates a new WorkbookTableSortApplyParameterSet
     */
    public WorkbookTableSortApplyParameterSet() {}
    /**
     * Instiaciates a new WorkbookTableSortApplyParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookTableSortApplyParameterSet(@Nonnull final WorkbookTableSortApplyParameterSetBuilder builder) {
        this.fields = builder.fields;
        this.matchCase = builder.matchCase;
        this.method = builder.method;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookTableSortApplyParameterSetBuilder newBuilder() {
        return new WorkbookTableSortApplyParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookTableSortApplyParameterSet
     */
    public static final class WorkbookTableSortApplyParameterSetBuilder {
        /**
         * The fields parameter value
         */
        @Nullable
        protected java.util.List<WorkbookSortField> fields;
        /**
         * Sets the Fields
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookTableSortApplyParameterSetBuilder withFields(@Nullable final java.util.List<WorkbookSortField> val) {
            this.fields = val;
            return this;
        }
        /**
         * The matchCase parameter value
         */
        @Nullable
        protected Boolean matchCase;
        /**
         * Sets the MatchCase
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookTableSortApplyParameterSetBuilder withMatchCase(@Nullable final Boolean val) {
            this.matchCase = val;
            return this;
        }
        /**
         * The method parameter value
         */
        @Nullable
        protected String method;
        /**
         * Sets the Method
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookTableSortApplyParameterSetBuilder withMethod(@Nullable final String val) {
            this.method = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookTableSortApplyParameterSetBuilder
         */
        @Nullable
        protected WorkbookTableSortApplyParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookTableSortApplyParameterSet build() {
            return new WorkbookTableSortApplyParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.fields != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("fields", fields));
        }
        if(this.matchCase != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("matchCase", matchCase));
        }
        if(this.method != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("method", method));
        }
        return result;
    }
}
